/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideEscalatorSideBlock;

public class NarrowEscalatorBlock
extends AbstractWalkwayBlock {
    public NarrowEscalatorBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SLOPE, (Comparable)((Object)WalkwaySlope.HORIZONTAL)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SLOPE});
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return (WalkwaySlope)((Object)state.getValue((Property)SLOPE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.getValue((Property)SLOPE));
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.NARROW_ESCALATOR_BOTTOM.get(facing);
            case WalkwaySlope.TOP -> EscalatedShapes.NARROW_ESCALATOR_TOP.get(facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.NARROW_ESCALATOR_MIDDLE.get(facing);
            default -> EscalatedShapes.NARROW_WALKWAY.get(facing);
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.getValue((Property)SLOPE));
        if (slope == WalkwaySlope.HORIZONTAL || slope == WalkwaySlope.TERMINAL) {
            return super.getCollisionShape(state, blockGetter, pos, context);
        }
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        WalkwayBlockEntity be = (WalkwayBlockEntity)this.getBlockEntity(blockGetter, pos);
        if (be == null) {
            return super.getCollisionShape(state, blockGetter, pos, context);
        }
        float visualOffset = be.getVisualProgress();
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.NARROW_ESCALATOR_BOTTOM_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.NARROW_ESCALATOR_MIDDLE_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.TOP -> EscalatedShapes.NARROW_ESCALATOR_TOP_STEPPED.getShape(visualOffset, facing);
            default -> super.getCollisionShape(state, blockGetter, pos, context);
        };
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return false;
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        return (BlockState)((BlockState)((BlockState)this.getWalkwaySet().getWideSideBlock(level, state, pos).setValue(HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(HORIZONTAL_FACING)))).setValue((Property)WideEscalatorSideBlock.LEFT, (Comparable)Boolean.valueOf(!left))).setValue((Property)SLOPE, (Comparable)((Object)((WalkwaySlope)((Object)state.getValue((Property)SLOPE)))));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }
}

